/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class SimpleProxyServer {
    public static void main(String[] args) throws IOException {
        try {
            if (args.length != 3) {
                throw new IllegalArgumentException("Wrong number of args.");
            }
            String host = args[0];
            int remoteport = Integer.parseInt(args[1]);
            int localport = Integer.parseInt(args[2]);
            System.out.println("Starting proxy for " + host + ":" + remoteport + " on port " + localport);
            SimpleProxyServer.runServer(host, remoteport, localport);
        }
        catch (Exception e) {
            System.err.println(e);
            System.err.println("Usage: java SimpleProxyServer <remotehost> <remoteport> <localport>");
        }
    }

    public static void runServer(String host, int remoteport, int localport) throws IOException {
        ServerSocket ss = new ServerSocket(localport);
        final byte[] request = new byte[10240];
        byte[] reply = new byte[10240];
        while (true) {
            IOException e3;
            Object var8_8;
            Socket client = null;
            Socket server = null;
            try {
                try {
                    client = ss.accept();
                    final InputStream from_client = client.getInputStream();
                    OutputStream to_client = client.getOutputStream();
                    try {
                        server = new Socket(host, remoteport);
                    }
                    catch (IOException e2) {
                        PrintWriter out = new PrintWriter(to_client);
                        out.print("Proxy server cannot connect to " + host + ":" + remoteport + ":\n" + e2 + "\n");
                        out.flush();
                        client.close();
                        var8_8 = null;
                        try {
                            if (server != null) {
                                server.close();
                            }
                            if (client == null) continue;
                            client.close();
                        }
                        catch (IOException e3) {}
                        continue;
                    }
                    InputStream from_server = server.getInputStream();
                    final OutputStream to_server = server.getOutputStream();
                    Thread t = new Thread(){

                        public void run() {
                            try {
                                int bytes_read;
                                while ((bytes_read = from_client.read(request)) != -1) {
                                    SimpleProxyServer.dumpBytes("\nClient-->Sever", request, bytes_read);
                                    to_server.write(request, 0, bytes_read);
                                    to_server.flush();
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            try {
                                to_server.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    };
                    t.start();
                    try {
                        int bytes_read;
                        while ((bytes_read = from_server.read(reply)) != -1) {
                            SimpleProxyServer.dumpBytes("\nServer-->Client", request, bytes_read);
                            to_client.write(reply, 0, bytes_read);
                            to_client.flush();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    to_client.close();
                }
                catch (IOException e4) {
                    System.err.println(e4);
                }
            }
            catch (Throwable throwable) {
                var8_8 = null;
                try {
                    if (server != null) {
                        server.close();
                    }
                    if (client != null) {
                        client.close();
                    }
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
            var8_8 = null;
            try {
                if (server != null) {
                    server.close();
                }
                if (client == null) continue;
                client.close();
            }
            catch (IOException e3) {
                continue;
            }
            break;
        }
    }

    private static void dumpBytes(String label, byte[] bytes, int count) {
        System.out.println(String.valueOf(label) + " (" + count + " bytes)");
        int off = 0;
        while (off < count) {
            String s = Integer.toHexString(off).toUpperCase();
            while (s.length() < 4) {
                s = String.valueOf('0') + s;
            }
            System.out.print(String.valueOf(s) + ": ");
            StringBuffer hexLine = new StringBuffer();
            StringBuffer charLine = new StringBuffer();
            int i = 0;
            while (i < 16) {
                if (i % 4 == 0) {
                    hexLine.append(" ");
                }
                if (off + i >= count) {
                    hexLine.append("  ");
                    charLine.append(" ");
                } else {
                    int binByte = bytes[off + i];
                    if (binByte < 0) {
                        binByte += 256;
                    }
                    if (binByte < 16) {
                        hexLine.append('0');
                    }
                    hexLine.append(Integer.toHexString(binByte).toUpperCase());
                    if (binByte >= 32) {
                        charLine.append((char)binByte);
                    } else {
                        charLine.append('.');
                    }
                }
                ++i;
            }
            System.out.print(hexLine);
            System.out.print("  ");
            System.out.println(charLine);
            off += 16;
        }
    }
}

