#!/usr/bin/perl
use MQSeries;
#use Time::HiRes qw( usleep ualarm gettimeofday tv_interval );

my $sq = $ARGV[0];
my $dq = $ARGV[1];

my $bufferlen=32000;
my $Hconn = MQCONN($Name, $CompCode, $Reason);
my $Options = MQOO_INPUT_AS_Q_DEF | MQOO_FAIL_IF_QUIESCING;
my $ObjDesc = { ObjectName => $sq };
my $Hobj = MQOPEN($Hconn,$ObjDesc,$Options,$CompCode,$Reason);
print"OPEN: $Reason\n";
my $MsgDesc = {MQMD_DEFAULT};
my $GetMsgOpts = { Options => MQGMO_FAIL_IF_QUIESCING | MQGMO_WAIT, WaitInterval => 600000, MatchOptions => MQMO_NONE };

my $POptions = MQOO_OUTPUT | MQOO_FAIL_IF_QUIESCING;
my $PObjDesc = { ObjectName => $dq };
my $PHobj = MQOPEN($Hconn,$PObjDesc,$POptions,$CompCode,$Reason);
my $PMsgDesc = $MsgDesc;    // set to {MQMD_DEFAULT} if you don't  want to maintain MsgId and CorrellId of the source message
my $PutMsgOpts = { Options => MQPMO_FAIL_IF_QUIESCING };
my $Buff;

while($Reason==MQRC_NONE)
{
    $bufferlen=30;
    my $MsgDesc = {MsgId=>MQMI_NONE,CorrelId=>MQCI_NONE,Encoding=>MQENC_NATIVE,CodedCharSetId=>MQCCSI_Q_MGR};
    $Buff = MQGET($Hconn, $Hobj, $MsgDesc, $GetMsgOpts, $bufferlen, $CompCode, $Reason);
    last if ($Reason!=MQRC_NONE);
    MQPUT($Hconn, $PHobj, $PMsgDesc, $PutMsgOpts, $Buff, $CompCode, $Reason);
}

print "REASON IS: $Reason\n" if ($Reason!=MQRC_NONE && $Reason!=MQRC_NO_MSG_AVAILABLE); 
MQCLOSE($Hconn,$PHobj,$COptions,$CompCode,$Reason);

MQCLOSE($Hconn,$Hobj,$COptions,$CompCode,$Reason);
print"close reason: $Reason\n";
MQDISC($Hconn,$CompCode,$Reason);
