// -----------------------------------------------------------------------------
// (c) Copyright IBM Corp. 1999 All rights reserved.
//
// The sample program(s) is/are owned by International Business Machines
// Corporation or one of its subsidiaries ("IBM") and is/are copyrighted and
// licensed, not sold.
//
// You may copy, modify, and distribute this/these sample program(s) in any form
// without payment to IBM, for any purpose including developing, using, marketing
// or distributing programs that include or are derivative works of the sample
// program(s).
//
// The sample program(s) is/are provided to you on an "AS IS" basis, without
// warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL WARRANTIES, EITHER
// EXPRESS OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Some jurisdictions do
// not allow for the exclusion or limitation of implied warranties, so the above
// limitations or exclusions may not apply to you.  IBM shall not be liable for
// any damages you suffer as a result of using, modifying or distributing the
// sample program(s) or its/their derivatives.
//
// Each copy of any portion of this/these sample program(s) or any derivative
// work, must include the above copyright notice and disclaimer of warranty.
//
// -----------------------------------------------------------------------------


// MSender is a Java program that reads a line of input from the keyboard and sends 
// it to a queue. Queue Name is passed in as a Parameter.
// To build: javac MSender.java
// To Run:   java MSender queue_name



import com.ibm.mq.*;
import java.io.*;

public class MSender {

  private static MQQueueManager qMgr;

/**
 * MSender constructor comment.
 */
public MSender() {
        super();
}
/**
 * This method was created in VisualAge.
 * @param args java.lang.String[]
 */
public static void main(String args[]) {
        try {
       if (args.length < 1) {
          System.out.println("Missing queue name");
       } else {
          System.out.println("MSender is running");

          // create a new instance of the sample program
          MSender mSender = new MSender();

          if (args.length > 1) {
             qMgr = new MQQueueManager(args[1]);
          } else {
             qMgr = new MQQueueManager("");
          }

          int openOptions = MQC.MQOO_OUTPUT;
          MQQueue q = qMgr.accessQueue(args[0],
                                openOptions,  null, null, null);

          // call method to send messages
          mSender.mPut(qMgr, q);


          // clean up connection
          q.close();
          qMgr.disconnect();
       }


        } catch (MQException ex) {
                System.out.println("MQ exception occurred : Completeion code "
                                                + ex.completionCode + " Reason code " + ex.reasonCode);
        }
}
/**
 * This method was created in VisualAge.
 *
 * @param       qMgr    - a MQ QueueManager object
 * @param       q       - a MQ Queue object
 *
 */

 public void mPut( MQQueueManager qMgr, MQQueue q) {
   try {

        // Define a MQ message buffer
        MQMessage mBuf = new MQMessage();

        // create message options
        MQPutMessageOptions pmo = new MQPutMessageOptions(); // accept defaults
        pmo.options = MQC.MQPMO_NONE;   // use defaults

        System.out.println("\nEnter a message:\"SOME TEXT <CR>\" to send, <CR> to exit");

        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader br     = new BufferedReader(isr);

        String runShow;
        do {
           runShow = br.readLine();
           if (runShow.length() > 0) {
              mBuf.clearMessage();                    //      reset the buffer
              mBuf.correlationId = MQC.MQCI_NONE;     //  set correlationId
              mBuf.messageId     = MQC.MQMI_NONE;     //      set messageId
              mBuf.writeString(runShow);              //  set the actual message
	    	  System.out.println("writing message");
              q.put(mBuf, pmo);               // put the message out on the queue
           }
        } while (runShow.length() > 0);


        } catch (MQException ex) {
           System.out.println("MQ exception occurred : Completeion code " +
                                   ex.completionCode + " Reason code " +
                                   ex.reasonCode);
        }
        catch (java.io.IOException ex) {
           System.out.println("An error occurred reading from message buffer: "+ex);
        }
}
}