       IDENTIFICATION DIVISION.
      ****************************************************************
      *                                                              *
      * Program name: AMQ0REQ0                                       *
      *                                                              *
      * Description: Sample COBOL program to put request messages    *
      *              to a message queue and show the replies         *
      *              (example using REPLY queue)                     *
      *                                                              *
      *  Statement:     Licensed Materials - Property of IBM         *                      
      *                                                              *      
      *                 04L1773, 5765-B73                            *            
      *                 04L1802, 5639-B42                            *            
      *                 04L1788, 5765-B74                            *            
      *                 04L1816, 5765-B75                            *            
      *                 04L1830, 5639-B43                            *            
      *                 (C) Copyright IBM Corp. 1994, 1998           *
      *                                                              *
      *                                                              *
      ****************************************************************
      *                                                              *
      * Function:                                                    *
      *                                                              *
      *                                                              *
      *   AMQ0REQ0 is a sample COBOL program to put messages to      *
      *   a message queue, and then to show the reply messages       *
      *                                                              *
      *   Note: AMQ0REQ0 will only receive replies to its requests   *
      *         if there is a program running, or triggered, to      *
      *         respond to them. Samples for Set, Inquire and        *
      *         Echo could be used for this purpose.                 *
      *                                                              *
      *      -- sample input is read using the ACCEPT verb,          *
      *         taking a blank entry to indicate the end of          *
      *         the input; the target queue is obtained from         *
      *         the console                                          *
      *                                                              *
      *      -- requests are sent to the queue named by parameter;   *
      *         replies are to SYSTEM.SAMPLE.REPLY, which can be     *
      *         either a local queue or a model queue from which     *
      *         a dynamic queue can be created                       *
      *                                                              *
      *      -- puts each input text line to the message queue,      *
      *         taking each line of text as the content of a         *
      *         request message                                      *
      *                                                              *
      *      -- displays the reply messages, assuming each           *
      *         message to represent a line of text                  *
      *                                                              *
      *      -- writes a message for each MQI reason other than      *
      *         MQRC-NONE; stops if there is a MQI completion        *
      *         code of MQCC-FAILED                                  *
      *                                                              *
      *    Program logic:                                            *
      *         display prompt for server queue name                 *
      *         ACCEPT the server queue name from the console        *
      *         MQCONNect to default queue manager                   *
      *         display name of server queue                         *
      *         MQOPEN target queue for OUTPUT                       *
      *         MQOPEN reply queue for EXCLUSIVE INPUT               *
      *         for each line in the input,                          *
      *         .  MQPUT request message with text to target queue   *
      *         while no MQI failures,                               *
      *         .  MQGET message from reply queue                    *
      *         .  display its content                               *
      *         MQCLOSE both queues                                  *
      *         MQDISConnect from queue manager                      *
      *                                                              *
      *                                                              *
      ****************************************************************
      *                                                              *
      *                                                              *
      *                                                              *
      *   Exceptions signaled:  none                                 *
      *   Exceptions monitored: none                                 *
      *                                                              *
      *   AMQ0REQ0 has no parameters                                 *
      *                                                              *
      ****************************************************************
       PROGRAM-ID. 'AMQ0REQ0'.

      ****************************************************************
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      *
      **  Declare MQI structures needed
      * MQI named constants
       01 MY-MQ-CONSTANTS.
          COPY CMQV.
      * Object Descriptor
       01 OBJECT-DESCRIPTOR.
          COPY CMQODV.
      * Message Descriptor
       01 MESSAGE-DESCRIPTOR.
          COPY CMQMDV.
      * Put message options
       01 PMOPTIONS.
          COPY CMQPMOV.
      * Get message options
       01 GMOPTIONS.
          COPY CMQGMOV.

      **   fixed reply queue name used in this example if local queue
      **   allow a dynamic queue to be created if  model queue
       01 REPLY-QUEUE  PIC X(48) VALUE 'SYSTEM.SAMPLE.REPLY'.
      **   ACTUAL-REPLY-QUEUE holds name of queue used
       01 ACTUAL-REPLY-QUEUE         PIC X(48) VALUE SPACES.

      ** note, sample uses defaults where it can
       01 QM-NAME                    PIC X(48) VALUE SPACES.
       01 HCONN                      PIC S9(9) BINARY.
       01 Q-HANDLE                   PIC S9(9) BINARY.
       01 REPLY-HANDLE               PIC S9(9) BINARY.
       01 OPTIONS                    PIC S9(9) BINARY.
       01 COMPLETION-CODE            PIC S9(9) BINARY.
       01 OPEN-CODE                  PIC S9(9) BINARY.
       01 CON-REASON                 PIC S9(9) BINARY.
       01 REASON                     PIC S9(9) BINARY.
       01 BUFFER                     PIC X(48).
       01 BUFFER-LENGTH              PIC S9(9) BINARY.
       01 REPLY.
          02 INFO48                  PIC X(48).
          02 INFO35                  PIC X(35).
       01 REPLY-LENGTH               PIC S9(9) BINARY.
       01 DATA-LENGTH                PIC S9(9) BINARY.
       01 TARGET-QUEUE               PIC X(48).

      ****************************************************************
       PROCEDURE DIVISION.
       P0.
      ** indicate that sample program has started
           DISPLAY 'AMQ0REQ0 start'.
      ****************************************************************
      *                                                              *
      *    Display prompt for the name of the target server queue    *
      *                                                              *
      ****************************************************************
           DISPLAY 'Please enter the name of the target server queue '

      ** get the target queue from StdIn.
           ACCEPT TARGET-QUEUE FROM CONSOLE.

      ****************************************************************
      *                                                              *
      *   Connect to default queue manager                           *
      *                                                              *
      ****************************************************************
           CALL 'MQCONN'
            USING QM-NAME, HCONN,
            COMPLETION-CODE, CON-REASON.

      *      report reason and stop if it failed
           IF COMPLETION-CODE IS EQUAL TO MQCC-FAILED
             DISPLAY 'MQCONN ended with reason code ' CON-REASON
             MOVE CON-REASON TO RETURN-CODE
             GOBACK
             END-IF.
      *
      ****************************************************************
      *                                                              *
      *    Display name of target queue given as parameter           *
      *                                                              *
      ****************************************************************
           DISPLAY 'Target Server Queue - ' TARGET-QUEUE.
      *
      ****************************************************************
      *                                                              *
      *   Open the target message queue for output (and fail if      *
      *   MQM is quiescing)                                          *
      *                                                              *
      ****************************************************************
       OPENS.
           MOVE TARGET-QUEUE TO MQOD-OBJECTNAME.
           ADD MQOO-OUTPUT MQOO-FAIL-IF-QUIESCING
                     GIVING OPTIONS.
           CALL 'MQOPEN'
            USING HCONN, OBJECT-DESCRIPTOR,
            OPTIONS, Q-HANDLE,
            OPEN-CODE, REASON.

      *      report reason, if any; stop if failed
           IF REASON IS NOT EQUAL TO MQRC-NONE
             DISPLAY 'MQOPEN ended with reason code ' REASON
             END-IF.

           IF OPEN-CODE IS EQUAL TO MQCC-FAILED
             DISPLAY 'unable to open target queue for output'
             MOVE REASON TO RETURN-CODE
             GOBACK
             END-IF.

      ****************************************************************
      *                                                              *
      *   Open the queue to receive reply messages                   *
      *   Allow a dynamic queue to be created from a model queue     *
      *   Record the name of the actual Queue used ( dynamic or      *
      *   fixed ) to be put into the REPLYTOQ field of the message   *
      *                                                              *
      ****************************************************************
       OPENR.
           MOVE REPLY-QUEUE TO MQOD-OBJECTNAME.
           ADD MQOO-INPUT-EXCLUSIVE MQOO-FAIL-IF-QUIESCING
                     GIVING OPTIONS.
           CALL 'MQOPEN'
            USING HCONN, OBJECT-DESCRIPTOR,
            OPTIONS, REPLY-HANDLE,
            OPEN-CODE, REASON.

      *      report reason, if any; stop if failed
           IF REASON IS NOT EQUAL TO MQRC-NONE
             DISPLAY 'MQOPEN ended with reason code ' REASON
             END-IF.

           IF OPEN-CODE IS EQUAL TO MQCC-FAILED
             DISPLAY 'unable to open reply queue'
           ELSE
             MOVE MQOD-OBJECTNAME TO ACTUAL-REPLY-QUEUE
             DISPLAY 'Reply Queue - ' ACTUAL-REPLY-QUEUE
             END-IF.

      ****************************************************************
      *                                                              *
      *   Put request messages to the target queue                   *
      *                                                              *
      ****************************************************************
       PUTS.
      **   Display prompt for the message(s)                         *
           DISPLAY 'Please enter the request message(s) '

           MOVE OPEN-CODE TO COMPLETION-CODE.
           PERFORM PUTR WITH TEST BEFORE
             UNTIL COMPLETION-CODE IS EQUAL TO MQCC-FAILED.

      ****************************************************************
      *                                                              *
      *   Get reply messages                                         *
      *                                                              *
      ****************************************************************
       GETS.
           MOVE OPEN-CODE TO COMPLETION-CODE.
           MOVE 300000 TO MQGMO-WAITINTERVAL.
      *                    (5 minute limit for the first wait)
           PERFORM GETR THRU DISPR WITH TEST BEFORE
             UNTIL COMPLETION-CODE IS EQUAL TO MQCC-FAILED.

      ****************************************************************
      *                                                              *
      *   Close both queues                                          *
      *                                                              *
      ****************************************************************
       CLOSES.
           MOVE MQCO-NONE TO OPTIONS.
           CALL 'MQCLOSE'
            USING HCONN, Q-HANDLE, OPTIONS,
            COMPLETION-CODE, REASON.

      *      report reason, if any
           IF REASON IS NOT EQUAL TO MQRC-NONE
             DISPLAY 'MQCLOSE (target) ended with reason code ' REASON
             END-IF.

      * close reply queue - if it was opened
           IF OPEN-CODE IS NOT EQUAL TO MQCC-FAILED
             CALL 'MQCLOSE'
              USING HCONN, REPLY-HANDLE, OPTIONS,
              COMPLETION-CODE, REASON

      *      report reason, if any
             IF REASON IS NOT EQUAL TO MQRC-NONE
               DISPLAY 'MQCLOSE (reply) ended with reason code '
                                                    REASON
               END-IF
             END-IF.

      ****************************************************************
      *                                                              *
      *  Disconnect from queue manager (if not previously connected) *
      *                                                              *
      ****************************************************************
       DISCS.
           IF CON-REASON IS NOT EQUAL TO MQRC-ALREADY-CONNECTED
             CALL 'MQDISC'
              USING HCONN, COMPLETION-CODE, REASON

      *      report reason, if any
             IF REASON IS NOT EQUAL TO MQRC-NONE
               DISPLAY 'MQDISC ended with reason code ' REASON
             END-IF
           END-IF.

       OVER.
      ** indicate that sample program has finished
           DISPLAY 'AMQ0REQ0 end'.
           MOVE ZERO TO RETURN-CODE.
           GOBACK.

      ****************************************************************
      *                                                              *
      *   Put one request to the target queue                        *
      *                                                              *
      ****************************************************************
       PUTR.
           MOVE SPACES TO BUFFER.
           ACCEPT BUFFER.
           IF BUFFER IS NOT EQUAL TO SPACES
             PERFORM PUTIT
           ELSE
             MOVE MQCC-FAILED TO COMPLETION-CODE.

       PUTIT.
           MOVE 48 to BUFFER-LENGTH.
           MOVE MQMT-REQUEST to MQMD-MSGTYPE.
           MOVE MQRO-EXCEPTION-WITH-DATA TO MQMD-REPORT.
           MOVE ACTUAL-REPLY-QUEUE TO MQMD-REPLYTOQ.

           CALL 'MQPUT'
            USING HCONN, Q-HANDLE,
            MESSAGE-DESCRIPTOR, PMOPTIONS,
            BUFFER-LENGTH, BUFFER,
            COMPLETION-CODE, REASON.

      *      report reason, if any
           IF REASON IS NOT EQUAL TO MQRC-NONE
             DISPLAY 'MQPUT ended with reason code ' REASON
             END-IF.

      ****************************************************************
      *                                                              *
      *   Get one reply message                                      *
      *                                                              *
      *   In order to read the messages in sequence, MSGID and       *
      *   CORRELID must have the default value.  MQGET sets them     *
      *   to the values for the message it returns, so re-initialise *
      *   them each time                                             *
      *                                                              *
      ****************************************************************
       GETR.
           MOVE MQMI-NONE TO MQMD-MSGID.
           MOVE MQCI-NONE TO MQMD-CORRELID.
           MOVE SPACES TO REPLY.
           ADD MQGMO-WAIT MQGMO-ACCEPT-TRUNCATED-MSG
                     GIVING MQGMO-OPTIONS.
           MOVE 83 to REPLY-LENGTH.

           CALL 'MQGET'
            USING HCONN, REPLY-HANDLE,
            MESSAGE-DESCRIPTOR, GMOPTIONS,
            REPLY-LENGTH, REPLY, DATA-LENGTH,
            COMPLETION-CODE, REASON.
      *      set 15 second limit for subsequent waits
           MOVE 15000 TO MQGMO-WAITINTERVAL.

      ****************************************************************
      *                                                              *
      *   Display reply or report received                           *
      *                                                              *
      ****************************************************************
       DISPR.
      ** report reason, if any
           IF REASON IS NOT EQUAL TO MQRC-NONE
             IF REASON IS EQUAL TO MQRC-NO-MSG-AVAILABLE
               DISPLAY 'no more replies'
             ELSE
               DISPLAY 'MQGET ended with reason code ' REASON
             END-IF
           END-IF.

      ** display reply or report
           IF COMPLETION-CODE IS NOT EQUAL TO MQCC-FAILED
             DISPLAY 'response <' INFO48 '>'
             IF MQMD-MSGTYPE IS EQUAL TO MQMT-REPORT
               DISPLAY '  report with feedback = ' MQMD-FEEDBACK
             ELSE
               IF DATA-LENGTH GREATER THAN 48
                 DISPLAY '         <' INFO35 '>'
               END-IF
             END-IF
             DISPLAY '          '
           END-IF.
      ****************************************************************
      *                                                              *
      * END OF AMQ0REQ0                                              *
      *                                                              *
      ****************************************************************
