      ******************************************************************
      **                                                              **
      **                  IBM MQSeries for Windows NT                 **
      **                                                              **
      **  COPYBOOK NAME:  CMQODL                                      **
      **                                                              **
      **  DESCRIPTION:    Object Descriptor Structure                 **
      **                                                              **
      ******************************************************************
      **  @START_COPYRIGHT@                                           **
      **  Licensed Materials - Property of IBM                        **
      **                                                              **
      **  04L1830, 5639-B43                                           **
      **                                                              **
      **  (C) Copyright IBM Corporation 1993, 1999.                   **
      **                                                              **
      **  Status: Version 5 Release 1                                 **
      **  @END_COPYRIGHT@                                             **
      ******************************************************************
      **                                                              **
      **  FUNCTION:       This file declares the structure MQOD,      **
      **                  which is used by the main MQI.              **
      **                                                              **
      **  PROCESSOR:      COBOL                                       **
      **                                                              **
      ******************************************************************
 
      **   MQOD structure
        10 MQOD.
      **    Structure identifier
         15 MQOD-STRUCID             PIC X(4).
      **    Structure version number
         15 MQOD-VERSION             PIC S9(9) BINARY.
      **    Object type
         15 MQOD-OBJECTTYPE          PIC S9(9) BINARY.
      **    Object name
         15 MQOD-OBJECTNAME          PIC X(48).
      **    Object queue manager name
         15 MQOD-OBJECTQMGRNAME      PIC X(48).
      **    Dynamic queue name
         15 MQOD-DYNAMICQNAME        PIC X(48).
      **    Alternate user identifier
         15 MQOD-ALTERNATEUSERID     PIC X(12).
      **    Number of object records present
         15 MQOD-RECSPRESENT         PIC S9(9) BINARY.
      **    Number of local queues opened successfully
         15 MQOD-KNOWNDESTCOUNT      PIC S9(9) BINARY.
      **    Number of remote queues opened successfully
         15 MQOD-UNKNOWNDESTCOUNT    PIC S9(9) BINARY.
      **    Number of queues that failed to open
         15 MQOD-INVALIDDESTCOUNT    PIC S9(9) BINARY.
      **    Offset of first object record from start of MQOD
         15 MQOD-OBJECTRECOFFSET     PIC S9(9) BINARY.
      **    Offset of first response record from start of MQOD
         15 MQOD-RESPONSERECOFFSET   PIC S9(9) BINARY.
      **    Address of first object record
         15 MQOD-OBJECTRECPTR        POINTER.
      **    Address of first response record
         15 MQOD-RESPONSERECPTR      POINTER.
      **    Alternate security identifier
         15 MQOD-ALTERNATESECURITYID PIC X(40).
      **    Resolved queue name
         15 MQOD-RESOLVEDQNAME       PIC X(48).
      **    Resolved queue manager name
         15 MQOD-RESOLVEDQMGRNAME    PIC X(48).
 
      ******************************************************************
      **  End of CMQODL                                               **
      ******************************************************************
